<?php
require_once('conf/conf.php');

// Ambil kd_dokter dari parameter URL
$kd_dokter = isset($_GET['kd_dokter']) ? $_GET['kd_dokter'] : '';

// Validasi kd_dokter
if(empty($kd_dokter)) {
    echo "<script>alert('Akses tidak sah!'); window.close();</script>";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Template Diagnosa</title>
    <link href="plugins/bootstrap/css/bootstrap.css" rel="stylesheet">
    <link href="plugins/jquery-datatable/skin/bootstrap/css/dataTables.bootstrap.css" rel="stylesheet">
    <style>
        body { padding: 15px; }
        .table > thead > tr > th {
            background: #2196F3;
            color: white;
        }
        .btn-pilih {
            padding: 3px 8px;
        }
    </style>
</head>
<body>
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover" id="tabelTemplate">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Keluhan Utama</th>
                    <th>Diagnosa Awal</th>
                    <th>Diagnosa utama</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $sql = "SELECT * FROM template_resume_pasien_ranap WHERE kd_dokter = '".$kd_dokter."' ORDER BY diagnosa_awal ASC";
                $hasil = bukaquery($sql);
                $no = 1;
                while($row = mysqli_fetch_array($hasil)) {
                    // Escape semua data untuk keamanan
                    $data = array_map(function($value) {
                        return str_replace('"', '&quot;', $value);
                    }, $row);
                ?>
                <tr>
                    <td><?php echo $no++; ?></td>
                    <td><?php echo $data['keluhan_utama']; ?></td>
                    <td><?php echo $data['diagnosa_awal']; ?></td>
                    <td><?php echo $data['diagnosa_utama']; ?></td>
                    <td>
                        <button type="button" class="btn btn-primary btn-pilih" 
                                onclick='pilihTemplate(<?php echo json_encode($data); ?>)'>
                            Pilih
                        </button>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

    <script src="plugins/jquery/jquery.min.js"></script>
    <script src="plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="plugins/jquery-datatable/jquery.dataTables.js"></script>
    <script src="plugins/jquery-datatable/skin/bootstrap/js/dataTables.bootstrap.js"></script>
    
    <script type="text/javascript">
    $(document).ready(function() {
        $('#tabelTemplate').DataTable({
            responsive: true,
            pageLength: 10,
            language: {
                search: "Cari:",
                lengthMenu: "Tampilkan _MENU_ data",
                zeroRecords: "Data tidak ditemukan",
                info: "Halaman _PAGE_ dari _PAGES_",
                infoEmpty: "Tidak ada data",
                infoFiltered: "(filter dari _MAX_ total data)",
                paginate: {
                    first: "Pertama",
                    last: "Terakhir",
                    next: "Selanjutnya",
                    previous: "Sebelumnya"
                }
            }
        });
    });

    function pilihTemplate(data) {
        // Kirim data ke parent window
        window.opener.setTemplate(data);
        // Tutup popup
        window.close();
    }
    </script>
</body>
</html> 